;
; application : View3ds ver. 0.04 - tiny .3ds files viewer.
; compiler    : FASM  1.65.13
; system      : KolibriOS/MenuetOS
; author      : Macgub aka Maciej Guba
; email       : macgub3@wp.pl
; web         : www.menuet.xt.pl
; Fell free to use this intro in your own distribution of KolibriOS/MenuetOS.
; Special greetings to all MenuetOS maniax in the world.
; I hope because my intros Christian Belive will be near to each of You.


; Some adjustments made by Madis Kalme
; madis.kalme@mail.ee
; I tried optimizing it a bit, but don't know if it was successful. The objects
; can be:
; 1) Read from a file (*.3DS standard)
; 2) Written in manually (at the end of the code)
;include 'proc32.inc'

SIZE_X equ 512
SIZE_Y equ 512				       ;      /////     I want definitely
TIMEOUT equ 4				       ;     ------     say:
ROUND equ 10				       ;     \ @ @/     keep smiling every
TEX_X equ 512	  ; texture width              ;      \ ./    / day.
TEX_Y equ 512	  ;         height             ;       \/    /
TEX_SHIFT equ 9  ; texture width shifting      ;     __||__ /
TEXTURE_SIZE EQU (TEX_X * TEX_Y)-1	       ;   /|      |
TEX equ  SHIFTING ;  TEX={SHIFTING | FLUENTLY} ;  / \      /
FLUENTLY = 0				       ; /   |    |
SHIFTING = 1				       ;     ------
CATMULL_SHIFT equ 8			       ;      |  |
LIGHT_SIZE equ 22			       ;      |  |
NON   =   0				       ;     -/  \-
MMX   =   1
SSE   =   2
Ext   =   MMX			;Ext={ NON | MMX | SSE}

; 0 for short names (Menuet-compatible), 1 for long names (Kolibri features)
USE_LFN = 1

use32
	org    0x0
	db     'MENUET01'	; 8 byte id
	dd     0x01		; header version
	dd     START		; start of code
	dd     I_END		; size of image
	dd     MEM_END		; memory for app
	dd     MEM_END		; esp
	dd     I_Param		; I_Param
	dd     0x0		; I_Icon

START:	  ; start of execution
	cld
	call   alloc_buffer_mem
	call   read_param
	call   read_from_disk
	cmp    eax,0
	jz     .read_f
      .gen:
	call   generate_object		 ; file b_procs
	jmp    .opt
      .read_f:
	call   read_from_file
     .opt:
	call   optimize_object1     ;  file b_procs.asm setpoint(0,0,0) in center and  calc all coords
				    ;  to be in <-1.0,1.0>
	call   read_from_real_list  ;  form real_points to points with scale and add x_offset and y_offset
;   integer coordinates still nedeed to calc triangles normal vectors
	call   make_random_lights
	call   normalize_all_light_vectors
	call   init_triangles_normals
	call   init_point_normals
   ;    call   init_envmap2
   ;    call   generate_texture2
	call   init_sincos_tab

	call   do_color_buffer	 ; intit color_map
	mov    edi,bumpmap
	call   calc_bumpmap
	call   calc_bumpmap_coords   ; bump and texture mapping
	call   draw_window


still:

	mov	eax,23		; wait here for event with timeout
	mov	ebx,TIMEOUT
	cmp	[speed_flag],1
	jne	.skip
	mov	eax,11
    .skip:
	int	0x40

	cmp	eax,1		; redraw request ?
	je	red
	cmp	eax,2		; key in buffer ?
	je	key
	cmp	eax,3		; button in buffer ?
	je	button

	jmp	noclose

    red:			; redraw
	call	draw_window

	jmp	noclose

    key:			; key
	mov	eax,2		; just read it and ignore
	int	0x40
	jmp	noclose

    button:			; button
	mov	eax,17		; get id
	int	0x40

	cmp	ah,1		; button id=1 ?
	jne	@f

	mov	eax,-1		; close this program
	int	0x40
      @@:
	cmp	ah,30
	jge	add_vec_buttons
	call	update_flags	      ; update flags and write labels of flags

				      ; do other operations according to flag
	cmp	ah,3		      ; ah = 3 -> shading model
	jne	.ch_another2
	cmp	[dr_flag],2
	jne	@f
	call	init_envmap2
     @@:
	cmp	[dr_flag],4
	jne	@f
	call	generate_texture2

     @@:
     .ch_another2:
			    ; ah = 5 -> scale-
	cmp	ah,5
	jne	@f
	mov	[scale],0.7
	fninit
	fld	[rsscale]
	fmul	[scale]
	fstp	[rsscale]

      @@:
	cmp	ah,6		     ; ah = 6 ->  scale+
	jne	@f
	mov	[scale],1.3
	fninit
	fld	[rsscale]
	fmul	[scale]
	fstp	[rsscale]

      @@:
	cmp	ah,9	; lights random                 ;    'flat'  0
	jne	.ch_another3				;    'grd '  1
	call	make_random_lights			;    'env '  2
	call	normalize_all_light_vectors		;    'bump'  3
	call	do_color_buffer   ; intit color_map     ;    'tex '  4
	cmp	[emboss_flag],1 			;    'pos '  5
	je	@f					;    'dots'  6
	cmp	[dr_flag],8
	jge	@f
	cmp	[dr_flag],2				;    'txgr'  7
	jl	.ch_another3				;    '2tex'  8
	cmp	[dr_flag],3				;    'btex'  9
	jg	.ch_another3
     @@:
	call	init_envmap2	; update env map if shading model = environment or bump
    .ch_another3:
	cmp	 ah,12
	jne	 .next_cmp
	call	 mirror
     .next_cmp:
	cmp	 ah,14
	jne	 @f
	call	 exchange
     @@:
	cmp	 ah,15
	jne	 @f
	cmp	 [emboss_flag],1
	call	 init_envmap2
     @@:
	cmp	 ah,18
	jne	 .nnnexxt
	mov	 bl,[generator_flag]
	or	 bl,bl
	jz	 .nnnexxt
	cmp	 bl,1
	jne	 @f
	call	 generate_object
	jmp	 .calc_norm
      @@:
	cmp	 bl,4
	jg	 @f
	movzx	 ax,bl		      ; ax < - object number
	call	 generate_object2
	jmp	.calc_norm
      @@:
	call	generate_object3
      .calc_norm:
	call	optimize_object1
	call	read_from_real_list
	call	init_triangles_normals
	call	init_point_normals
	call	calc_bumpmap_coords   ; bump and texture mapping

     .nnnexxt:

	jmp	noclose


			       ; there are 6 navigation buttons each
   add_vec_buttons:	       ; can move: object, camera,.. list is open
			       ;
	cmp	ah,30
	jne	.next
	cmp	[move_flag],1
	je	@f

	sub	[vect_y],10
 ;       sub     [yo],10
	jmp	.next
      @@:
	sub	[yobs],10	  ;  observator = camera position
      .next:
	cmp	ah,31
	jne	.next1
	cmp	[move_flag],1
	je	@f

	add	[vect_z],10
  ;      add     [zo],10
	jmp	.next1
      @@:
	add	[zobs],10	  ;  observator = camera position
     .next1:
	cmp	ah,33
	jne	.next2
	cmp	[move_flag],1
	je	@f

	sub	[vect_x],10
   ;     sub     [xo],10
	jmp	.next2
      @@:
	sub	[xobs],10	  ;  observator = camera position
      .next2:
	cmp	ah,32
	jne	.next3
	cmp	[move_flag],1
	je	@f

	add	[vect_x],10
  ;      add     [xo],10
	jmp	.next3
      @@:
	add	[xobs],10	  ;  observator = camera position
      .next3:
	cmp	ah,34
	jne	.next4
	cmp	[move_flag],1
	je	@f

	sub	[vect_z],10
   ;     sub     [zo],10
	jmp	.next4
      @@:
	sub	[zobs],10	  ;  observator = camera position
      .next4:
	cmp	ah,35
	jne	.next5
	cmp	[move_flag],1
	je	@f

      ;  call    add_vector
	add	[vect_y],10
;        add     [yo],10                ; update rotary point
	jmp	.next5
      @@:
	add	[yobs],10	  ;  observator = camera position
      .next5:



    noclose:

	cmp	[r_flag],2
	jne	.no_x
	mov	ax,[angle_x]
	inc	ax
	cmp	ax,360
	jl	@f
	xor	ax,ax
      @@:
	mov	[angle_x],ax
	xor	bx,bx
     ;   mov     [angle_y],bx
	mov	[angle_z],bx
	jmp	.end_rot

      .no_x:
	cmp	[r_flag],0
	jne	.no_y
	mov	bx,[angle_y]
	inc	bx
	cmp	bx,360
	jl	@f
	xor	bx,bx
      @@:
	mov	[angle_y],bx
	xor	bx,bx
    ;    mov     [angle_x],bx
	mov	[angle_z],bx
	jmp	.end_rot
      .no_y:

	cmp	[r_flag],1
	jne	.end_rot
	mov	cx,[angle_x]
	inc	cx
	cmp	cx,360
	jl	@f
	xor	cx,cx
      @@:
	mov	[angle_z],0
	mov	[angle_y],cx
	mov	[angle_x],cx
     .end_rot:

	mov	esi,angle_x
	mov	edi,matrix
	call	make_rotation_matrix
;    RDTSC
;    push eax
	mov	esi,real_points
	mov	edi,rotated_points_r
	mov	ebx,matrix
	movzx	ecx,[points_count_var]
	call	rotary

	mov	esi,point_normals
	mov	edi,point_normals_rotated
	mov	ebx,matrix
	movzx	ecx,[points_count_var]
	call	rotary
;    RDTSC
;    pop    ebx
;    sub    eax,ebx
;    sub    eax,41
;    push   eax

	mov	esi,rotated_points_r
	mov	edi,points_rotated
	movzx	ecx,[points_count_var]
	call	translate_points

;       movzx   ecx,[points_count_var]
;       mov     esi,point_normals                      ; instead this copy normals
;       mov     edi,point_normals_rotated              ; and points in one proc
;       call    copy_normals
   ; copy normals and rotate the copy using sin/cosbeta - best way
    ;   movzx   ecx,[points_count_var]
    ;   mov     ebx,point_normals_rotated
    ;   call    rotate_normals

    ;   call    copy_points
    ;   call    rotate_points
;        cmp     [dr_flag],5
;        jne     @f
;        call    calc_attenuation_light
;     @@:
	cmp	[fire_flag],0
	jne	@f
	call	clrscr		; clear the screen
     @@:
	cmp	[catmull_flag],1  ;non sort if Catmull = on
	je	.no_sort
	call	sort_triangles
      .no_sort:
	cmp	[dr_flag],7	  ; fill if 2tex and texgrd
	jge	@f
	cmp	[catmull_flag],0  ;non fill if Catmull = off
	je	.non_f
	cmp	[dr_flag],6	  ; non fill if dots
	je	.non_f
      @@:
	call	fill_Z_buffer	  ; make background
     .non_f:
    RDTSC
    push eax
	cmp	[dr_flag],6
	jne	@f
	call	 draw_dots
	jmp	 .blurrr
      @@:
	call	draw_triangles	; draw all triangles from the list
      .blurrr:
	cmp	[fire_flag],0
	jne	@f
	cmp	[blur_flag],0
	je	.no_blur  ; no blur, no fire
	movzx	ecx,[blur_flag]
	call	blur_screen    ; blur and fire
	jmp	.no_blur
    @@:
	cmp	[emboss_flag],0
	jne	.emb	       ; if emboss=true -> no fire
	movzx	ecx,[fire_flag]
	call	blur_screen    ; blur and fire
    .no_blur:		       ; no blur, no fire
	cmp	[emboss_flag],0
	je	@f
     .emb:
	call	do_emboss

      @@:


    RDTSC
    sub eax,[esp]
    sub eax,41
;    pop     eax

    mov     ecx,10
  .dc:
    xor     edx,edx
    mov     edi,10
    div     edi
    add     dl,30h
    mov     [STRdata+ecx-1],dl
    loop    .dc
    pop eax

    mov     eax,7	    ; put image
    mov     ebx,screen
    mov     ecx,SIZE_X shl 16 + SIZE_Y
    mov     edx,5 shl 16 + 20
    int     0x40


    mov  eax,4			   ; function 4 : write text to window
    mov  ebx,5*65536+23 	   ; [x start] *65536 + [y start]
    mov  ecx,-1
    mov  edx,STRdata		   ; pointer to text beginning
    mov  esi,10 		   ; text length
    int  40h



   jmp	   still

;--------------------------------------------------------------------------------
;-------------------------PROCEDURES---------------------------------------------
;--------------------------------------------------------------------------------
include "tex3.inc"
include "flat_cat.inc"

include "tex_cat.inc"
include "bump_cat.inc"
include "3dmath.inc"
include "grd3.inc"
include "flat3.inc"
include "bump3.inc"
include "b_procs.inc"
include "a_procs.inc"
include "grd_cat.inc"
include "bump_tex.inc"
include "grd_tex.inc"
include "two_tex.inc"
;include "bump_tex.inc"
include "matrix.inc"

alloc_buffer_mem:
    movzx    ecx,[size_x]
    movzx    eax,[size_y]
    mul      ecx
    lea      ecx,[eax*3]
    push     ecx
    shl      eax,2
    add      ecx,eax
    add      ecx,MEM_END
    mov      ebx,1
    mov      eax,64	; allocate mem  - resize app mem
    int      0x40
    mov      [screen_ptr],MEM_END
    mov      [Zbuffer_ptr],MEM_END
    pop      ecx
    add      [Zbuffer_ptr],ecx
ret

update_flags:
; updates flags and writing flag description
; in    ah - button number
	push	ax
	mov	edi,menu
      .ch_another:
	cmp	ah,byte[edi]	 ; ah = button id
	jne	@f
	mov	bl,byte[edi+11]  ; max_flag + 1
	cmp	bl,255
	je	.no_write
	inc	byte[edi+12]	 ; flag
	cmp	byte[edi+12],bl
	jne	.write
	mov	byte[edi+12],0
	jmp	.write
      @@:
	add	edi,17
	cmp	byte[edi],-1
	jne	.ch_another
     .write:
;     clreol   {pascal never dies}
;          * eax = 13 - function number
;  * ebx = [coordinate on axis x]*65536 + [size on axis x]
;  * ecx = [coordinate on axis y]*65536 + [size on axis y]
;  * edx = color 0xRRGGBB or 0x80RRGGBB for gradient fill

	mov	eax,13				 ; function 13 write rectangle
	movzx	ecx,byte[edi]
	sub	cl,2
	lea	ecx,[ecx*3]
	lea	ecx,[ecx*5]
	add	ecx,28
	shl	ecx,16
	add	ecx,14				;  ecx = [coord y]*65536 + [size y]
	mov	ebx,(SIZE_X+12+70)*65536+25	; [x start] *65536 + [size x]
	mov	edx,0x00000000			;  color  0x00RRGGBB
	int	0x40

	mov	eax,4				; function 4 : write text to window
	movzx	ebx,byte[edi]
	sub	bl,2
	lea	ebx,[ebx*3]
	lea	ebx,[ebx*5]
	add	ebx,(SIZE_X+12+70)*65536+28	; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff			; font 1 & color ( 0xF0RRGGBB )
	movzx	edx,byte[edi+12]		; current flag
	shl	edx,2				; * 4 = text length
	add	edx,dword[edi+13]		; pointer to text beginning
	mov	esi,4				; text length -
						; flag description 4 characters
	int	0x40

     .no_write:
	pop	ax
ret
normalize_all_light_vectors:
	mov	edi,lights
     ;    movzx   ecx,[all_lights_size]
     ;    add     ecx,ecx
     ;   mov     ecx,lightsend
     @@:
	call	normalize_vector	   ;       3dmath.inc
	add	edi,LIGHT_SIZE
	cmp	edi,lightsend	;ecx
	jl	@b
ret

calc_bumpmap_coords:	  ; map texture, bump
macro .comment222
{				 ; planar mapping
	mov	esi,points
	mov	edi,tex_points
      @@:
	 add	 esi,2
	 movsd
	 cmp	 dword[esi],dword -1
	 jne	 @b
}
;      .Pi2  equ dword[ebp-4]

;      mov   ebp,esp
;      sub   esp,4

      fninit			 ; spherical mapping around y axle
      fldpi
      fadd	st,st
;      fstp      .Pi2
      mov	esi,real_points
      mov	edi,tex_points
      movzx	ecx,[points_count_var]
      inc	ecx

   @@:
      fld	dword[esi]     ; x coord
      fld	dword[esi+8]   ; z coord
      fpatan		       ; arctg(st1/st)
;      fdiv      .Pi2
      fdiv	st0,st1
      fimul	[tex_x_div2]
      fiadd	[tex_x_div2]
      fistp	word[edi]      ; x

      fld	dword[esi+4]   ; y coord
      fld	dword[esi]     ; x
      fmul	st,st0
      fld	dword[esi+4]   ; y
      fmul	st,st0
      fld	dword[esi+8]   ; z
      fmul	st,st0
      faddp
      faddp
      fsqrt
      fpatan
      fldpi
      fdivp
      fimul    [tex_y_div2]
      fiadd    [tex_y_div2]
      fistp    word[edi+2]     ; y

      add      esi,12
      add      edi,4
      loop     @b
      ffree    st0

;      mov      esp,ebp
ret


init_envmap2:	      ; do env_map using many light sources
;env_map 512 x 512 x 3 bytes
.temp  equ word   [ebp-2]
.nEy   equ word  [ebp-4]
.nEx   equ word  [ebp-6]
.col_r equ    [ebp-8]
.col_g equ    [ebp-9]
.col_b equ    [ebp-10]

	 push	  ebp
	 mov	  ebp,esp
	 sub	  esp,20
	 mov	  edi,envmap
	 fninit

	 mov	  dx,- TEX_Y / 2 ;256   ; dx - vertical coordinate = y
    .ie_ver:
	 mov	  cx,- TEX_X / 2 ;256   ; cx - horizontal coord = x
    .ie_hor:
	 xor	  ebx,ebx
	 mov	  dword .col_b, 0
     .light:
	 lea	  esi,[lights+ebx]
	 fld	  dword[esi]	 ; light vector x cooficient
	 fimul	  [tex_x_div2] ;[i256]
	 mov	  .temp,cx
	 fisubr   .temp
	 fistp	  .nEx
	 fld	  dword[esi+4]	 ; light vector y cooficient
	 fimul	  [tex_y_div2] ;[i256]
	 mov	  .temp,dx
	 fisubr   .temp
	 fistp	  .nEy

	 cmp	  .nEx,- TEX_X / 2 ;256
	 jl	  .update_counters
	 cmp	  .nEy,- TEX_Y / 2 ;256
	 jl	  .update_counters
	 cmp	  .nEx,TEX_X / 2 ;256
	 jg	  .update_counters
	 cmp	  .nEy,TEX_Y / 2 ;256
	 jg	  .update_counters

	 fild	  .nEx
	 fmul	  st,st0
	 fild	  .nEy
	 fmul	  st,st0
	 faddp
	 fsqrt
	 fisubr   [i256]
	 fmul	  [env_const]
	 fidiv	  [i256]   ; st - 'virtual' dot product

	 fcom	  [dot_max]
	 fstsw	  ax
	 sahf
	 jb	  @f
	 ffree	  st
	 fld1	  ;[dot_max]
      @@:
	 fcom	  [dot_min]
	 fstsw	  ax
	 sahf
	 ja	  @f
	 ffree	  st
	 fldz	  ;[dot_min]
      @@:
	 push	  ebp
	 movzx	  ax,byte[esi+21]
	 push	  ax  ;- shines
	 mov	  al,byte[esi+14]   ; b    orginal color
	 push	  ax
	 mov	  al,byte[esi+13]   ; g
	 push	  ax
	 mov	  al,byte[esi+12]   ; r
	 push	  ax
	 mov	  al,byte[esi+20]   ; b     max color
	 push	  ax
	 mov	  al,byte[esi+19]   ; g
	 push	  ax
	 mov	  al,byte[esi+18]   ; r
	 push	  ax
	 mov	  al,byte[esi+17]   ; b    min col
	 push	  ax
	 mov	  al,byte[esi+16]   ; g
	 push	  ax
	 mov	  al,byte[esi+15]   ; r
	 push	  ax
	 push	  eax	      ; earlier - dot pr
      ;  fstp     .dot_product
      ;  push     .dot_product
	 call	  calc_one_col
	 pop	  ebp
	 ; eax-0x00rrggbb
	 cmp	  al,.col_b
	 jbe	  @f
	 mov	  .col_b,al
   @@:			      ;  eax - ggbb00rr
	 shr	  ax,8
	 cmp	  al,.col_g
	 jbe	  @f
	 mov	  .col_g,al
   @@:			      ;  eax - bb0000gg
	 shr	  eax,16
	 cmp	  al,.col_r
	 jbe	  @f
	 mov	  .col_r,al
   @@:
   .update_counters:			 ; update and jump when neccesery
	 add	  ebx,LIGHT_SIZE
	 cmp	  bx,[all_lights_size]
	 jl	  .light    ; next_light
	 mov	  eax,dword .col_b
	 stosd
	 dec	  edi

	 inc	  cx
	 cmp	  cx,TEX_X / 2 ;256
	 jne	  .ie_hor

	 inc	  dx
	 cmp	  dx,TEX_Y / 2 ;256
	 jne	 .ie_ver

	 mov	 esp,ebp
	 pop	 ebp
ret

do_color_buffer:	 ; do color buffer for Gouraud, flat shading
;env_map 512 x 512 x 3 bytes    ; many lights using
.temp  equ word   [ebp-2]
.nz    equ dword  [ebp-6]  ; dword
.ny    equ dword  [ebp-10]
.nx    equ dword  [ebp-14]
.col_r equ    [ebp-16]
.col_g equ    [ebp-17]
.col_b equ    [ebp-18]

	 push	  ebp
	 mov	  ebp,esp
	 sub	  esp,20
	 mov	  edi,color_map
	 fninit

	 mov	  dx,- TEX_Y / 2 ;-256   ; dx - vertical coordinate = y
    .ie_ver:
	 mov	  cx,- TEX_X / 2 ;256   ; cx - horizontal coord = x
    .ie_hor:
	 mov	  .temp,cx
	 fild	  .temp
	 fidiv	  [i256]   ;st = Nx - vector normal x cooficient
	 fst	  .nx
	 fmul	  st,st0
	 mov	  .temp,dx
	 fild	  .temp
	 fidiv	  [i256]   ; st = Ny - vector normal y coeficient
	 fst	  .ny
	 fmul	  st,st0
	 faddp
	 fld1
	 fchs
	 faddp
	 fabs
	 fsqrt
	 fchs
	 fstp	  .nz		   ; st - Nz - vect normal z coeficient
	 xor	  ebx,ebx
	 mov	  dword .col_b, 0
     .light:
	 push	  edi	;env_map
	 lea	  esi,[lights+ebx]
	 lea	  edi,.nx
	 call	  dot_product
	 pop	  edi
	 fcom	  [dot_min]
	 fstsw	  ax
	 sahf
	 ja	  .env_ok1  ;compare with dot_max
	 ffree	  st

	jmp	  .update_counters
      .env_ok1:
	 fcom	 [dot_max]
	 fstsw	 ax
	 sahf
	 jb	 .env_ok2     ; calc col
	 ffree	 st
	 jmp	 .update_counters
      .env_ok2: 	   ;calc col
	 push	  ebp
	 movzx	  ax,byte[esi+21]
	 push	  ax  ;- shines
	 mov	  al,byte[esi+14]   ; b    orginal color
	 push	  ax
	 mov	  al,byte[esi+13]   ; g
	 push	  ax
	 mov	  al,byte[esi+12]   ; r
	 push	  ax
	 mov	  al,byte[esi+20]   ; b     max color
	 push	  ax
	 mov	  al,byte[esi+19]   ; g
	 push	  ax
	 mov	  al,byte[esi+18]   ; r
	 push	  ax
	 mov	  al,byte[esi+17]   ; b    min col
	 push	  ax
	 mov	  al,byte[esi+16]   ; g
	 push	  ax
	 mov	  al,byte[esi+15]   ; r
	 push	  ax
	 push	  eax	      ; earlier - dot pr
      ;  fstp     .dot_product
      ;  push     .dot_product
	 call	  calc_one_col
	 pop	  ebp
	 ; eax-0x00rrggbb
	 cmp	  al,.col_b
	 jbe	  @f
	 mov	  .col_b,al
   @@:
	 shr	  ax,8
	 cmp	  al,.col_g
	 jbe	  @f
	 mov	  .col_g,al
   @@:
	 shr	  eax,16
	 cmp	  al,.col_r
	 jbe	  @f
	 mov	  .col_r,al
  @@:
 .update_counters:				    ; update and jump when neccesery
	add	ebx,LIGHT_SIZE
	cmp	bx,[all_lights_size]
	jl	.light	  ; next_light
	mov	eax,dword .col_b
	stosd
	dec	edi

	inc	cx
	cmp	cx,TEX_X / 2 ;256
	jne	.ie_hor

	inc	dx
	cmp	dx,TEX_X / 2 ;256
	jne	.ie_ver

    .env_done:
	 mov	 esp,ebp
	 pop	 ebp
ret

init_triangles_normals:
	mov	ebx,triangles_normals
	mov	ebp,triangles
     @@:
	push	ebx
	mov	ebx,vectors
	movzx	esi,word[ebp]	       ; first point index
	lea	esi,[esi*3]
	lea	esi,[points+esi*2]     ; esi - pointer to 1st 3d point
	movzx	edi,word[ebp+2]        ; second point index
	lea	edi,[edi*3]
	lea	edi,[points+edi*2]     ; edi - pointer to 2nd 3d point
	call	make_vector
	add	ebx,12
	mov	esi,edi
	movzx	edi,word[ebp+4]        ; third point index
	lea	edi,[edi*3]
	lea	edi,[points+edi*2]
	call	make_vector
	mov	edi,ebx 		; edi - pointer to 2nd vector
	mov	esi,ebx
	sub	esi,12			; esi - pointer to 1st vector
	pop	ebx
	call	cross_product
	mov	edi,ebx
	call	normalize_vector
	add	ebp,6
	add	ebx,12
	cmp	dword[ebp],-1
	jne	@b
ret

init_point_normals:
.x equ dword [ebp-4]
.y equ dword [ebp-8]
.z equ dword [ebp-12]
.point_number equ word [ebp-26]
.hit_faces    equ word [ebp-28]

	fninit
	mov	  ebp,esp
	sub	  esp,28
	mov	  edi,point_normals
	mov	  .point_number,0
    .ipn_loop:
	mov	  .hit_faces,0
	mov	  .x,0
	mov	  .y,0
	mov	  .z,0
	mov	  esi,triangles
	xor	  ecx,ecx	       ; ecx - triangle number
    .ipn_check_face:
	xor	  ebx,ebx	       ; ebx - 'position' in one triangle
    .ipn_check_vertex:
	movzx	  eax,word[esi+ebx]    ;  eax - point_number
	cmp	  ax,.point_number
	jne	  .ipn_next_vertex
	push	  esi
	mov	  esi,ecx
	lea	  esi,[esi*3]
	lea	  esi,[triangles_normals+esi*4]
       ; shl       esi,2
       ; add       esi,triangles_normals

	fld	  .x
	fadd	  dword[esi+vec_x]	 ; vec_x this defined in 3dmath.asm - x cooficient
	fstp	  .x			 ; of normal vactor
	fld	  .y
	fadd	  dword[esi+vec_y]
	fstp	  .y
	fld	  .z
	fadd	  dword[esi+vec_z]
	fstp	  .z
	pop	  esi
	inc	  .hit_faces
	jmp	  .ipn_next_face
    .ipn_next_vertex:
	add	  ebx,2
	cmp	  ebx,6
	jne	  .ipn_check_vertex
    .ipn_next_face:
	add	  esi,6
	inc	  ecx
	cmp	  cx,[triangles_count_var]
	jne	  .ipn_check_face

	fld	  .x
	fidiv	  .hit_faces
	fstp	  dword[edi+vec_x]
	fld	  .y
	fidiv	  .hit_faces
	fstp	  dword[edi+vec_y]
	fld	  .z
	fidiv	  .hit_faces
	fstp	  dword[edi+vec_z]
	call	  normalize_vector
	add	  edi,12  ;type vector 3d
	inc	  .point_number
	mov	  dx,.point_number
	cmp	  dx,[points_count_var]
	jne	  .ipn_loop

	mov	  esp,ebp
ret

;add_vector:
; in : ax, bx, cx - x, y, z vectors to add
;        mov ebp,points
;       @@:
;        add word[ebp],ax
;        add word[ebp+2],bx
;        add word[ebp+4],cx
;        add ebp,6
;        cmp dword[ebp],-1
;        jne @b
;ret
;do_scale:
;        fninit
;        mov ebp,points
;      .next_sc:
;        fld1
;        fsub [scale]
;        fld st
;        fimul [xo]
;        fld [scale]
;        fimul word[ebp] ;x
;        faddp
;        fistp word[ebp]
;        fld st
;        fimul [yo]
;        fld [scale]
;        fimul word[ebp+2]
;        faddp
;        fistp word[ebp+2]
;        fimul [zo]
;        fld [scale]
;        fimul word[ebp+4]
;        faddp
;        fistp word[ebp+4]
;        add ebp,6
;        cmp dword[ebp],-1
;        jne .next_sc
;ret
sort_triangles:
	mov	esi,triangles
	mov	edi,triangles_with_z
	mov	ebp,points_rotated

    make_triangle_with_z:	;makes list with triangles and z position
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	movzx	ecx,word[ebp+eax*2+4]

	movzx	eax,word[esi+2]
	lea	eax,[eax*3]
	add	cx,word[ebp+eax*2+4]

	movzx	eax,word[esi+4]
	lea	eax,[eax*3]
	add	cx,word[ebp+eax*2+4]

	mov	ax,cx
       ; cwd
       ; idiv    word[i3]
	movsd			; store vertex coordinates
	movsw
	stosw			; middle vertex coordinate  'z' in triangles_with_z list
	cmp	dword[esi],-1
	jne	make_triangle_with_z
	movsd			; copy end mark
	mov	eax,4
	lea	edx,[edi-8-trizdd]
	mov	[high],edx
	call	quicksort
	mov	eax,4
	mov	edx,[high]
	call	insertsort
	jmp	end_sort

    quicksort:
	mov	ecx,edx
	sub	ecx,eax
	cmp	ecx,32
	jc	.exit
	lea	ecx,[eax+edx]
	shr	ecx,4
	lea	ecx,[ecx*8-4]; i
	mov	ebx,[trizdd+eax]; trizdd[l]
	mov	esi,[trizdd+ecx]; trizdd[i]
	mov	edi,[trizdd+edx]; trizdd[h]
	cmp	ebx,esi
	jg	@f		; direction NB! you need to negate these to invert the order
      if Ext=NON
	mov	[trizdd+eax],esi
	mov	[trizdd+ecx],ebx
	mov	ebx,[trizdd+eax-4]
	mov	esi,[trizdd+ecx-4]
	mov	[trizdd+eax-4],esi
	mov	[trizdd+ecx-4],ebx
	mov	ebx,[trizdd+eax]
	mov	esi,[trizdd+ecx]
      else
	movq	mm0,[trizdq+eax-4]
	movq	mm1,[trizdq+ecx-4]
	movq	[trizdq+ecx-4],mm0
	movq	[trizdq+eax-4],mm1
	xchg	ebx,esi
      end if
      @@:
	cmp	ebx,edi
	jg	@f		; direction
      if Ext=NON
	mov	[trizdd+eax],edi
	mov	[trizdd+edx],ebx
	mov	ebx,[trizdd+eax-4]
	mov	edi,[trizdd+edx-4]
	mov	[trizdd+eax-4],edi
	mov	[trizdd+edx-4],ebx
	mov	ebx,[trizdd+eax]
	mov	edi,[trizdd+edx]
      else
	movq	mm0,[trizdq+eax-4]
	movq	mm1,[trizdq+edx-4]
	movq	[trizdq+edx-4],mm0
	movq	[trizdq+eax-4],mm1
	xchg	ebx,edi
      end if
      @@:
	cmp	esi,edi
	jg	@f		; direction
      if Ext=NON
	mov	[trizdd+ecx],edi
	mov	[trizdd+edx],esi
	mov	esi,[trizdd+ecx-4]
	mov	edi,[trizdd+edx-4]
	mov	[trizdd+ecx-4],edi
	mov	[trizdd+edx-4],esi
      else
	movq	mm0,[trizdq+ecx-4]
	movq	mm1,[trizdq+edx-4]
	movq	[trizdq+edx-4],mm0
	movq	[trizdq+ecx-4],mm1
;        xchg    ebx,esi
      end if
      @@:
	mov	ebp,eax 	; direction
	add	ebp,8	   ;   j
      if Ext=NON
	mov	esi,[trizdd+ebp]
	mov	edi,[trizdd+ecx]
	mov	[trizdd+ebp],edi
	mov	[trizdd+ecx],esi
	mov	esi,[trizdd+ebp-4]
	mov	edi,[trizdd+ecx-4]
	mov	[trizdd+ecx-4],esi
	mov	[trizdd+ebp-4],edi
      else
	movq	mm0,[trizdq+ebp-4]
	movq	mm1,[trizdq+ecx-4]
	movq	[trizdq+ecx-4],mm0
	movq	[trizdq+ebp-4],mm1
      end if
	mov	ecx,edx    ;   i; direction
	mov	ebx,[trizdd+ebp]; trizdd[j]
      .loop:
	sub	ecx,8		; direction
	cmp	[trizdd+ecx],ebx
	jl	.loop		; direction
      @@:
	add	ebp,8		; direction
	cmp	[trizdd+ebp],ebx
	jg	@b		; direction
	cmp	ebp,ecx
	jge	@f		; direction
      if Ext=NON
	mov	esi,[trizdd+ecx]
	mov	edi,[trizdd+ebp]
	mov	[trizdd+ebp],esi
	mov	[trizdd+ecx],edi
	mov	edi,[trizdd+ecx-4]
	mov	esi,[trizdd+ebp-4]
	mov	[trizdd+ebp-4],edi
	mov	[trizdd+ecx-4],esi
      else
	movq	mm0,[trizdq+ecx-4]
	movq	mm1,[trizdq+ebp-4]
	movq	[trizdq+ebp-4],mm0
	movq	[trizdq+ecx-4],mm1
      end if
	jmp	.loop
      @@:
      if Ext=NON
	mov	esi,[trizdd+ecx]
	mov	edi,[trizdd+eax+8]
	mov	[trizdd+eax+8],esi
	mov	[trizdd+ecx],edi
	mov	edi,[trizdd+ecx-4]
	mov	esi,[trizdd+eax+4]
	mov	[trizdd+eax+4],edi
	mov	[trizdd+ecx-4],esi
      else
	movq	mm0,[trizdq+ecx-4]
	movq	mm1,[trizdq+eax+4]; dir
	movq	[trizdq+eax+4],mm0; dir
	movq	[trizdq+ecx-4],mm1
      end if
	add	ecx,8
	push	ecx edx
	mov	edx,ebp
	call	quicksort
	pop	edx eax
	call	quicksort
      .exit:
    ret
    insertsort:
	mov	esi,eax
      .start:
	add	esi,8
	cmp	esi,edx
	ja	.exit
	mov	ebx,[trizdd+esi]
      if Ext=NON
	mov	ecx,[trizdd+esi-4]
      else
	movq	mm1,[trizdq+esi-4]
      end if
	mov	edi,esi
      @@:
	cmp	edi,eax
	jna	@f
	cmp	[trizdd+edi-8],ebx
	jg	@f		   ; direction
      if Ext=NON
	mov	ebp,[trizdd+edi-8]
	mov	[trizdd+edi],ebp
	mov	ebp,[trizdd+edi-12]
	mov	[trizdd+edi-4],ebp
      else
	movq	mm0,[trizdq+edi-12]
	movq	[trizdq+edi-4],mm0
      end if
	sub	edi,8
	jmp	@b
      @@:
      if Ext=NON
	mov	[trizdd+edi],ebx
	mov	[trizdd+edi-4],ecx
      else
	movq	[trizdq+edi-4],mm1
      end if
	jmp	.start
      .exit:
    ret
   end_sort:
    ; translate triangles_with_z to sorted_triangles
	mov	esi,triangles_with_z
      ;  mov     edi,sorted_triangles
	mov	 edi,triangles
    again_copy:
      if Ext=NON
	movsd
	movsw
	add	esi,2
      else
	movq	mm0,[esi]
	movq	[edi],mm0
	add	esi,8
	add	edi,6
      end if
	cmp	dword[esi],-1
	jne	again_copy
;      if Ext=MMX
;        emms
;      end if
	movsd  ; copy end mark too
ret

clrscr:
	mov	edi,screen
	mov	ecx,SIZE_X*SIZE_Y*3/4
	xor	eax,eax
      if Ext=NON
	rep	stosd
      else
	pxor	mm0,mm0
      @@:
	movq	[edi+00],mm0
	movq	[edi+08],mm0
	movq	[edi+16],mm0
	movq	[edi+24],mm0
	add	edi,32
	sub	ecx,8
	jnc	@b
      end if
ret


draw_triangles:
	mov esi,triangles
    .again_dts:
	mov ebp,points_rotated
      if Ext=NON
	movzx	eax,word[esi]
	mov	[point_index1],ax
	lea	eax,[eax*3]
	add	eax,eax
	push	ebp
	add	ebp,eax
	mov	eax,[ebp]
	mov	dword[xx1],eax
	mov	eax,[ebp+4]
	mov	[zz1],ax
	pop	ebp


	movzx	eax,word[esi+2]
	mov	[point_index2],ax
	lea	eax,[eax*3]
	add	eax,eax
	push	ebp
	add	ebp,eax
	mov	eax,[ebp]
	mov	dword[xx2],eax
	mov	eax,[ebp+4]
	mov	[zz2],ax
	pop	ebp


	movzx	eax,word[esi+4]        ; xyz3 = [ebp+[esi+4]*6]
	mov	[point_index3],ax
	lea	eax,[eax*3]
	add	eax,eax
    ;    push    ebp
	add	ebp,eax
	mov	eax,[ebp]
	mov	dword[xx3],eax
	mov	eax,[ebp+4]
	mov	[zz3],ax
      else
	mov	eax,dword[esi]		 ; don't know MMX
	mov	dword[point_index1],eax
       ; shr     eax,16
       ; mov     [point_index2],ax
	mov	ax,word[esi+4]
	mov	[point_index3],ax
	movq	mm0,[esi]
	pmullw	mm0,qword[const6]
	movd	eax,mm0
	psrlq	mm0,16
	movd	ebx,mm0
	psrlq	mm0,16
	movd	ecx,mm0
	and	eax,0FFFFh
	and	ebx,0FFFFh
	and	ecx,0FFFFh
	movq	mm0,[ebp+eax]
	movq	mm1,[ebp+ebx]
	movq	mm2,[ebp+ecx]
	movq	qword[xx1],mm0
	movq	qword[xx2],mm1
	movq	qword[xx3],mm2
;        emms
      end if				  ; *********************************
	push esi			  ;
	fninit				  ; DO culling AT FIRST
	cmp	[culling_flag],1	  ; (if culling_flag = 1)
	jne	.no_culling
	mov	esi,point_index1	  ; *********************************
	mov	ecx,3			  ;
      @@:
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	shl	eax,2
	lea	eax,[eax+point_normals_rotated]
	fld	dword[eax+8]		 ; *****************************
	ftst				 ; CHECKING OF Z COOFICIENT OF
	fstsw	ax			 ; NORMAL VECTOR
	sahf
	jb     @f
	ffree	st
	loop	@b
	jmp	.end_draw   ; non visable
      @@:
	ffree	st  ;is visable
      .no_culling:
	cmp	[dr_flag],0		  ; draw type flag
	je	.flat_draw
	cmp	[dr_flag],2
	je	.env_mapping
	cmp	[dr_flag],3
	je	.bump_mapping
	cmp	[dr_flag],4
	je	.tex_mapping
	cmp	[dr_flag],5
	je	.rainbow
	cmp	[dr_flag],7
	je	.grd_tex
	cmp	[dr_flag],8
	je	.two_tex
	cmp	[dr_flag],9
	je	.bump_tex
				      ; ****************
	mov	esi,point_index3      ; do Gouraud shading
	mov	ecx,3
      .again_grd_draw:
	movzx	eax,word[esi]
	shl	eax,2
	lea	 eax,[eax*3+point_normals_rotated]
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]	 ; x cooficient of normal vector
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[esp-2]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]	  ; y cooficient
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[esp-4]

	movzx	 eax,word[esp-4]
	movzx	 ebx,word[esp-2]
	shl	 eax,TEX_SHIFT
	add	 eax,ebx
	lea	 eax,[eax*3+color_map]
	mov	 eax,dword[eax]
	cmp	[catmull_flag],1      ; put on stack z coordinate if necessary
	jne	 @f
	lea	 edx,[ecx*3]
	push	 word[edx*2+xx1-2]    ; zz1 ,2 ,3
      @@:
	ror	 eax,16 	      ; eax -0xxxrrggbb -> 0xggbbxxrr
	xor	 ah,ah
	push	 ax	    ;r
	rol	 eax,8		      ; eax-0xggbb00rr -> 0xbb00rrgg
	xor	 ah,ah
	push	 ax	    ;g
	shr	 eax,24
	push	 ax	    ;b

	sub	 esi,2
	dec	 cx
	jnz	 .again_grd_draw
	jmp	 .both_draw

   ;     movzx   edi,[point_index3]   ;gouraud shading according to light vector
   ;     lea     edi,[edi*3]
   ;     lea     edi,[4*edi+point_normals_rotated] ; edi - normal
   ;     mov     esi,light_vector
   ;     call    dot_product
   ;     fabs
   ;     fimul   [orginal_color_r]
   ;     fistp   [temp_col]
   ;     and     [temp_col],0x00ff
   ;     push    [temp_col]
   ;     push    [temp_col]
   ;     push    [temp_col]

   ;     movzx   edi,[point_index2]
   ;     lea     edi,[edi*3]
   ;     lea     edi,[4*edi+point_normals_rotated] ; edi - normal
   ;     mov     esi,light_vector
   ;     call    dot_product
   ;     fabs
   ;     fimul   [orginal_color_r]
   ;     fistp    [temp_col]
   ;     and     [temp_col],0x00ff
   ;     push    [temp_col]
   ;     push    [temp_col]
   ;     push    [temp_col]

   ;     movzx   edi,[point_index1]
   ;     lea     edi,[edi*3]
   ;     lea     edi,[4*edi+point_normals_rotated] ; edi - normal
   ;     mov     esi,light_vector
   ;     call    dot_product
   ;     fabs
   ;     fimul   [orginal_color_r]
   ;     fistp   [temp_col]
   ;     and     [temp_col],0x00ff
   ;     push    [temp_col]
   ;     push    [temp_col]
   ;     push    [temp_col]
   .rainbow:
	cmp	[catmull_flag],1      ; put on stack z coordinate if necessary
	jne	 @f
	push	 [zz3]
      @@:
	mov	 eax,dword[yy3]
	mov	 ebx,0x00ff00ff
	and	 eax,ebx
	push	 eax
	neg	 al
	push	 ax
	cmp	[catmull_flag],1
	jne	 @f
	push	 [zz2]
      @@:
	mov	 eax,dword[yy2]
	and	 eax,ebx
	push	 eax
	neg	 al
	push	 ax
	cmp	[catmull_flag],1
	jne	 @f
	push	 [zz1]
      @@:
	mov	 eax,dword[yy1]
	and	 eax,ebx
	push	 eax
	neg	 al
	push	 ax
    .both_draw:
	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	lea	edi,[screen]
	cmp	[catmull_flag],0
	je	@f
  ;      lea     esi,[Z_buffer]
	mov	esi,[Zbuffer_ptr]
	call	gouraud_triangle_z
	jmp	.end_draw
       @@:
	call	gouraud_triangle
	jmp	.end_draw

     .flat_draw:		     ;**************************
				     ; FLAT DRAWING
	movzx	eax,[point_index1]
	movzx	ebx,[point_index2]
	movzx	ecx,[point_index3]
	shl	eax,2
	shl	ebx,2
	shl	ecx,2
	lea	eax,[eax*3+point_normals_rotated]
	lea	ebx,[ebx*3+point_normals_rotated]
	lea	ecx,[ecx*3+point_normals_rotated]
	fld	dword[eax]	; x cooficient of normal vector
	fadd	dword[ebx]
	fadd	dword[ecx]
	fidiv	[i3]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	dword[esp-4]	; x temp variables
	fld	dword[eax+4]	; y cooficient of normal vector
	fadd	dword[ebx+4]
	fadd	dword[ecx+4]
	fidiv	[i3]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	dword[esp-8]   ;  y
	mov	edx,dword[esp-8]
	shl	edx,TEX_SHIFT
	add	edx,dword[esp-4]
	lea	eax,[3*edx+color_map]
	mov	edx,dword[eax]

	and	edx,0x00ffffff	  ; edx = 0x00rrggbb



     ;   mov     ax,[zz1]      ; z position depend draw
     ;   add     ax,[zz2]
     ;   add     ax,[zz3]
     ;   cwd
     ;   idiv    [i3] ;    = -((a+b+c)/3+130)
     ;   add     ax,130
     ;   neg     al
     ;   xor     edx,edx
     ;   mov     ah,al           ;set color according to z position
     ;   shl     eax,8
     ;   mov     edx,eax

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
       ; mov     edi,screen
	lea	edi,[screen]
	cmp	[catmull_flag],0
	je	@f
   ;     lea     esi,[Z_buffer]
	mov	esi,[Zbuffer_ptr]
	push	word[zz3]
	push	word[zz2]
	push	word[zz1]
	call	flat_triangle_z
	jmp	.end_draw
      @@:
	call	draw_triangle
	jmp	.end_draw
      .env_mapping:
       ; fninit
	cmp	[catmull_flag],0
	je	@f
	push	[zz3]
	push	[zz2]
	push	[zz1]
      @@:
	mov	esi,point_index1
	sub	esp,12
	mov	edi,esp
	mov	ecx,3
      @@:
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	shl	eax,2
	add	eax,point_normals_rotated
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi+2]

	add	edi,4
	add	esi,2
	loop	@b

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	esi,envmap
	cmp	[catmull_flag],0
	je	@f
  ;      mov     edx,Z_buffer
	mov	edx,[Zbuffer_ptr]
	call	tex_triangle_z
	jmp	.end_draw
      @@:
	call	tex_triangle
	jmp	.end_draw
      .bump_mapping:
	; fninit
	cmp	[catmull_flag],0
	je	@f
;        push    Z_buffer
	push	[Zbuffer_ptr]
	push	[zz3]
	push	[zz2]
	push	[zz1]
      @@:
	mov	esi,point_index1
	sub	esp,12
	mov	edi,esp
	mov	ecx,3
      @@:
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	shl	eax,2
	add	eax,point_normals_rotated
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi+2]

	add	edi,4
	add	esi,2
	loop	@b

	movzx  esi,[point_index3]      ; bump map coords
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index2]
	shl    esi,2
	add    esi,tex_points
;       lea    esi,[esi*3]
;       lea    esi,[points+2+esi*2]
	push   dword[esi]
  ;     push   dword[xx2]
	movzx  esi,[point_index1]
	shl    esi,2
	add    esi,tex_points
;       lea     esi,[esi*3]
;       lea     esi,[points+2+esi*2]
	push   dword[esi]
   ;    push     dword[xx1]

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	esi,envmap
	mov	edx,bumpmap	       ;BUMP_MAPPING

	cmp	[catmull_flag],0
	je	@f
	call	bump_triangle_z
	jmp	.end_draw
      @@:
	call	bump_triangle
	jmp	.end_draw

      .tex_mapping:

	; fninit
	cmp	[catmull_flag],0
	je	@f
	push	[zz3]
	push	[zz2]
	push	[zz1]
      @@:
	movzx  esi,[point_index3]      ; tex map coords
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index2]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index1]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	esi,texmap
	cmp	[catmull_flag],0
	je	@f
   ;     mov     edx,Z_buffer
	mov	edx,[Zbuffer_ptr]
	call	tex_triangle_z
 ;       call    tex_plus_grd_trianlgle
	jmp	.end_draw
      @@:
	call	tex_triangle
	jmp	.end_draw
;      .ray:
;        grd_triangle according to points index
;        cmp     [catmull_flag],0
;        je      @f
;        push    [zz3]                   ; spot light with attenuation
;     @@:
;        movzx   eax,[point_index3]      ; env_map - points color list
;        shl     eax,1                   ; each color as word, 0x00rr00gg00bb..
;        lea     eax,[3*eax+bumpmap]
;        push    word[eax]
;        push    word[eax+2]
;        push    word[eax+4]
;        cmp     [catmull_flag],0
;        je      @f
;        push    [zz2]
;    @@:
;        movzx   eax,[point_index2]      ; env_map - points color list
;        shl     eax,1                   ; each color as word, 0x00rr00gg00bb..
;        lea     eax,[eax*3+bumpmap]
;        push    word[eax]
;        push    word[eax+2]
;        push    word[eax+4]
;        cmp     [catmull_flag],0
;        je      @f
;        push    [zz1]
;     @@:
;        movzx   eax,[point_index1]      ; env_map - points color list
;        shl     eax,1                   ; each color as word, 0xrr00gg00bb00..
;        lea     eax,[eax*3+bumpmap]
;        push    word[eax]
;        push    word[eax+2]
;        push    word[eax+4]
;        jmp     .both_draw

     .grd_tex:		  ; smooth shading + texture
	 push	ebp
	 mov	ebp,esp
	 sub	esp,4
	 push	ebp

	 movzx	esi,[point_index3]	; tex map coords
	 shl	esi,2
	 add	esi,tex_points
	 push	dword[esi]		; texture coords as first
	 movzx	esi,[point_index2]	; group of parameters
	 shl	esi,2
	 add	esi,tex_points
	 push	dword[esi]
	 movzx	esi,[point_index1]
	 shl	esi,2
	 add	esi,tex_points
	 push	dword[esi]

	 mov	 esi,point_index3
	 mov	 ecx,3

      .aagain_grd_draw:

	lea	 edx,[ecx*3]
	push	 word[edx*2+xx1-2]    ; zz1 ,2 ,3

	movzx	eax,word[esi]
	shl	eax,2
	lea	 eax,[eax*3+point_normals_rotated]
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]	 ; x cooficient of normal vector
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[ebp-2]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]	  ; y cooficient
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[ebp-4]

	movzx	 eax,word[ebp-4]
	movzx	 ebx,word[ebp-2]
	shl	 eax,TEX_SHIFT
	add	 eax,ebx
	lea	 eax,[eax*3+color_map]
	mov	 eax,dword[eax]

	ror	 eax,16 	      ; eax -0xxxrrggbb -> 0xggbbxxrr
	xor	 ah,ah
	push	 ax	    ;r
	rol	 eax,8		      ; eax-0xggbb00rr -> 0xbb00rrgg
	xor	 ah,ah
	push	 ax	    ;g
	shr	 eax,24
	push	 ax	    ;b

	sub	 esi,2
	dec	 cx
	jnz	 .aagain_grd_draw

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	edx,texmap
	mov	esi,[Zbuffer_ptr]

	call	tex_plus_grd_triangle

	pop	ebp
	mov	esp,ebp
	pop	ebp
	jmp	.end_draw

      .two_tex:
	push	[Zbuffer_ptr]

	push	word[zz3]
	push	word[zz2]
	push	word[zz1]

	movzx  esi,[point_index3]      ; tex map coords
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index2]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index1]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]

	mov	esi,point_index1     ; env coords
	sub	esp,12
	mov	edi,esp
	mov	ecx,3
      @@:
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	shl	eax,2
	add	eax,point_normals_rotated
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi+2]

	add	edi,4
	add	esi,2
	loop	@b

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	esi,texmap
	mov	edx,envmap

	call	two_tex_triangle_z
	jmp	.end_draw

   .bump_tex:
	movzx  esi,[point_index3]      ; tex map coords
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index2]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index1]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]

	push  dword texmap

	push  [Zbuffer_ptr]
	xor   edi,edi

	push	word[zz3]
	push	word[zz2]
	push	word[zz1]

	mov	esi,point_index1     ; env coords
	sub	esp,12
	mov	edi,esp
	mov	ecx,3
      @@:
	movzx	eax,word[esi]
	lea	eax,[eax*3]
	shl	eax,2
	add	eax,point_normals_rotated
	; texture x=(rotated point normal -> x * 255)+255
	fld	dword[eax]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi]
	; texture y=(rotated point normal -> y * 255)+255
	fld	dword[eax+4]
	fimul	[correct_tex]
	fiadd	[correct_tex]
	fistp	word[edi+2]

	add	edi,4
	add	esi,2
	loop	@b

;        push  dword 1 shl 16 + 1  ; emap coords
;        push  dword 127 shl 16 + 1
;        push  dword 127 shl 16 + 127

	movzx  esi,[point_index3]      ; bump map coords
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]
	movzx  esi,[point_index2]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]

	movzx  esi,[point_index1]
	shl    esi,2
	add    esi,tex_points
	push   dword[esi]

;        push  dword 1 shl 16 + 127
;        push  dword 127 shl 16 + 127
;        push  dword 1 shl 16 + 1  ; bump coords

	mov	eax,dword[xx1]
	ror	eax,16
	mov	ebx,dword[xx2]
	ror	ebx,16
	mov	ecx,dword[xx3]
	ror	ecx,16
	mov	edi,screen
	mov	esi,envmap
	mov	edx,bumpmap

	call bump_tex_triangle_z

      .end_draw:
	pop	esi
	add	esi,6
	cmp	dword[esi],-1
	jne	.again_dts
ret


fill_Z_buffer:
	mov	eax,0x70000000
      ;  mov     edi,Z_buffer
	mov	edi,[Zbuffer_ptr]
	mov	ecx,SIZE_X*SIZE_Y
	rep	stosd
ret

read_from_file:
	mov	edi,triangles
	xor	ebx,ebx
	xor	ebp,ebp
	mov	[points_count_var],0
	mov	[triangles_count_var],0
	mov	esi,SourceFile
	cmp	[esi],word 4D4Dh
	jne	.exit ;Must be legal .3DS file
;        cmp     dword[esi+2],EndFile-SourceFile
;        jne     .exit ;This must tell the length
	mov	eax,dword[esi+2]
	add	eax,esi
	mov	[EndFile],eax	 ;

	add	esi,6
      @@:
	cmp	[esi],word 3D3Dh
	je	@f
	add	esi,[esi+2]
	jmp	@b
      @@:
	add	esi,6
      .find4k:
	cmp	[esi],word 4000h
	je	@f
	add	esi,[esi+2]
	cmp	esi,[EndFile]
	jc	.find4k
	jmp	.exit
      @@:
	add	esi,6
      @@:
	cmp	[esi],byte 0
	je	@f
	inc	esi
	jmp	@b
      @@:
	inc	esi
      @@:
	cmp	[esi],word 4100h
	je	@f
	add	esi,[esi+2]
	jmp	@b
      @@:
	add	esi,6
      @@:
	cmp	[esi],word 4110h
	je	@f
	add	esi,[esi+2]
	jmp	@b
      @@:
	movzx	ecx,word[esi+6]
	add	[points_count_var],cx

	mov	edx,ecx
	add	esi,8
     @@:
	fld	dword[esi+4]
	fstp	dword[real_points+ebx*2+0]  ; x
     ;   fmul    [sscale]
     ;   fadd    [xoffset]
	fld	dword[esi+8]
     ;   fchs
	fstp   dword[real_points+ebx*2+4]  ; y
     ;   fmul    [sscale]
     ;   fadd    [yoffset]
	fld	dword[esi+0]
     ;   fchs
	fstp   dword[real_points+ebx*2+8]  ; z
     ;   fmul    [sscale]

     ;   fistp   word[points+ebx+4]
     ;   fistp   word[points+ebx+2]
     ;   fistp   word[points+ebx+0]

	add	ebx,6
	add	esi,12
	dec	ecx
	jnz	@b
      @@:
  ;      mov     dword[points+ebx],-1
	mov	dword[real_points+ebx*2],-1	   ; end mark (not always in use)
      @@:
	cmp	[esi],word 4120h
	je	@f
	add	esi,[esi+2]
	jmp	@b
      @@:
	movzx	ecx,word[esi+6]
	add	[triangles_count_var],cx
	add	esi,8
	;mov     edi,triangles
      @@:
	movsd
	movsw
	add	word[edi-6],bp
	add	word[edi-4],bp
	add	word[edi-2],bp
	add	esi,2
	dec	ecx
	jnz	@b
	add	ebp,edx
	jmp	.find4k
	mov	eax,-1 ;<---mark if OK
      .exit:
	mov	dword[edi],-1
ret

read_from_real_list:
;                         read from real_points to points list
;                         convert floats to integer, rescale, add x_offset,y_offeset
    lea     esi,[real_points]
    lea     edi,[points]
    fninit
    movzx   ecx,[points_count_var]

  @@:
    fld     dword[esi]
    fmul    [rsscale]
    fiadd   [x_offset]
    fistp   word[edi]
    fld     dword[esi+4]
    fmul    [rsscale]
    fiadd   [y_offset]
    fistp   word[edi+2]
    fld     dword[esi+8]
    fmul    [rsscale]
    fiadd   [z_offset]
    fistp   word[edi+4]
    add     edi,6
    add     esi,12
    dec     ecx
    jnz     @b
    mov     dword[edi],-1	     ; end mark (not always in use)
ret

read_from_disk:
if USE_LFN
    mov     eax, 70
    mov     ebx, file_info
    int     0x40

    inc     ebx
    mov     [fsize],ebx

    cmp     eax,6
    jnz     @f
    xor     eax,eax	;;;;---
  @@:
else
    mov      eax,58
    mov      ebx,file_info
    int      0x40

    mov      eax,ebx
    shr      eax,9
    inc      eax
    mov      [fsize],eax
;    mov      ecx,ebx
;    add      ecx,MEM_END
;    mov      ebx,1
;    mov      eax,64     ; allocate mem  - resize app mem
			; for points and  triangles
    int      0x40

    mov      eax,58
    mov      ebx,file_info
    int      0x40
end if
  ;  eax = 0   -> ok file loaded
ret
read_param:
    mov        esi,I_Param
    cmp        dword[esi],0
    je	       .end
    cmp        byte[esi],'/'
    je	       .copy
    mov        edi,esi
    mov        ecx,25	; 25 - would be enought
    repe       scasb
    jne        .end
    dec        edi
    mov        esi,edi
 .copy:
    mov 	edi,file_name
    mov 	ecx,50
    rep 	movsd
 .end:
ret
buttons:				      ; draw some buttons (all but navigation and close )
	mov	edi,menu
      .again:
	mov	eax,8			      ; function 8 : define and draw button
	mov	ebx,(SIZE_X+10)*65536+62      ; [x start] *65536 + [x size]
	movzx	ecx,byte[edi]		      ; button id = position+2
	sub	cl,2
	lea	ecx,[ecx*5]
	lea	ecx,[ecx*3]
	add	ecx,25
	shl	ecx,16
	add	ecx,12
	movzx	edx,byte[edi]			; button id
	mov	esi,0x6688dd			; button color RRGGBB
	int	0x40
	 ; BUTTON  LABEL
	mov	eax,4				; function 4 : write text to window
	movzx	ebx,byte[edi]
	sub	bl,2				; button id, according to position
	lea	ebx,[ebx*3]
	lea	ebx,[ebx*5]
	add	ebx,(SIZE_X+12)*65536+28	; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff			; font 1 & color ( 0xF0RRGGBB )
	lea	edx,[edi+1]			; pointer to text beginning
	mov	esi,10				; text length
	int	0x40
	cmp	byte[edi+11],255		; if max_flag=255
	je	@f				; skip
	; flag description
;       mov     eax,4                           ; function 4 : write text to window
;       movzx   ebx,byte[edi]
;       sub     bl,2
;       lea     ebx,[ebx*3]
;       lea     ebx,[ebx*5]
;       add     ebx,(SIZE_X+12+70)*65536+28     ; [x start] *65536 + [y start]
	add	ebx,70*65536
;       mov     ecx,0x20ddeeff                  ; font 1 & color ( 0xF0RRGGBB )
	movzx	edx,byte[edi+12]		; current flag
	shl	edx,2				; * 4 = text length
	add	edx,dword[edi+13]		; pointer to text beginning
	mov	esi,4				; text length
	int	0x40

    @@:
	add	edi,17
	cmp	byte[edi],-1
	jnz	.again
ret
;   *********************************************
;   *******  WINDOW DEFINITIONS AND DRAW ********
;   *********************************************
    draw_window:
	mov	eax,12		; function 12:tell os about windowdraw
	mov	ebx,1		; 1, start of draw
	int	0x40

	; DRAW WINDOW
	mov	eax,0		; function 0 : define and draw window
	mov	ebx,100*65536;+SIZE_X;+80+30 ; [x start] *65536 + [x size]
	mov	ecx,100*65536;+SIZE_Y;+30    ; [y start] *65536 + [y size]
	mov	bx,[size_x]
	add	bx,110
	mov	cx,[size_y]
	add	cx,30
	mov	edx,0x02000000	; color of work area RRGGBB,8->color gl
	mov	esi,0x805080d0	; color of grab bar  RRGGBB,8->color gl
	mov	edi,0x005080d0	; color of frames    RRGGBB
	int	0x40

	; WINDOW LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,8*65536+8	; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelt	; pointer to text beginning
	mov	esi,labellen-labelt	; text length
	int	0x40

	; CLOSE BUTTON
	mov	eax,8		; function 8 : define and draw button
	movzx	ebx,[size_x]
	shl	ebx,16
	add	ebx, 91 shl 16 + 12
;        mov     ebx,(SIZE_X+80+30-19)*65536+12     ; [x start] *65536 + [x size]
	mov	ecx,5*65536+12	; [y start] *65536 + [y size]
	mov	edx,1		; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40

	call	buttons 	; more buttons


	; ADD VECTOR LABEL      ; add vector buttons - 30 ++
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12)*65536+(28+140+15*10)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelvector      ; pointer to text beginning
	mov	esi,labelvectorend-labelvector	   ; text length
	int	0x40
	 ; VECTOR Y- BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10+20)*65536+62-42	   ; [x start] *65536 + [x size]
	mov	ecx,(140+25+15*11)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,30		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR Y- LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12+20)*65536+(28+140+15*11)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelyminus      ; pointer to text beginning
	mov	esi,labelyminusend-labelyminus	   ; text length
	int	0x40
	; VECTOR Z+ BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10+41)*65536+62-41	   ; [x start] *65536 + [x size]
	mov	ecx,(25+140+15*11)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,31		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR Z+ LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12+41)*65536+(28+140+15*11)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelzplus	    ; pointer to text beginning
	mov	esi,labelzplusend-labelzplus	 ; text length
	int	0x40
	; VECTOR x- BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10)*65536+62-41	; [x start] *65536 + [x size]
	mov	ecx,(25+140+15*12)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,32		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR x- LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12)*65536+(28+140+15*12)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelxminus      ; pointer to text beginning
	mov	esi,labelxminusend-labelxminus	   ; text length
	int	0x40
	; VECTOR x+ BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10+41)*65536+62-41	   ; [x start] *65536 + [x size]
	mov	ecx,(25+140+15*12)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,33		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR x+ LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12+41)*65536+(28+140+15*12)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelxplus	    ; pointer to text beginning
	mov	esi,labelxplusend-labelxplus	 ; text length
	int	0x40
	; VECTOR z- BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10)*65536+62-41	; [x start] *65536 + [x size]
	mov	ecx,(25+140+15*13)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,34		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR z- LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12)*65536+(28+140+15*13)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelzminus      ; pointer to text beginning
	mov	esi,labelzminusend-labelzminus	   ; text length
	int	0x40
       ;VECTOR Y+ BUTTON
	mov	eax,8		; function 8 : define and draw button
	mov	ebx,(SIZE_X+10+20)*65536+62-42	   ; [x start] *65536 + [x size]
	mov	ecx,(25+140+15*13)*65536+12  ; [y start] *65536 + [y size]
	mov	edx,35		 ; button id
	mov	esi,0x6688dd	; button color RRGGBB
	int	0x40
	;VECTOR Y+ LABEL
	mov	eax,4		; function 4 : write text to window
	mov	ebx,(SIZE_X+12+20)*65536+(28+140+15*13)   ; [x start] *65536 + [y start]
	mov	ecx,0x20ddeeff	; font 1 & color ( 0xF0RRGGBB )
	mov	edx,labelyplus	    ; pointer to text beginning
	mov	esi,labelyplusend-labelyplus	 ; text length
	int	0x40

	mov	eax,12		; function 12:tell os about windowdraw
	mov	ebx,2		; 2, end of draw
	int	0x40
	ret


   ; DATA AREA  ************************************

	i3		dw	3
	i256		dw	256
;        light_vector    dd      0.0,0.0,-1.0
	dot_max 	dd	1.0	 ; dot product max and min
	dot_min 	dd	0.0
	env_const	dd	1.05
	correct_tex	dw	255
	tex_x_div2	dw	TEX_X  / 2
	tex_y_div2	dw	TEX_Y  / 2
	xobs		dw	0 ;SIZE_X / 2 ;200 ;observer  = camera
	yobs		dw	0 ;SIZE_Y / 2 ;200 ;coordinates
	zobs		dw	-500
	size_x		dw	SIZE_X
	size_y		dw	SIZE_Y

	angle_counter dw 0
	piD180	      dd 0.017453292519943295769236907684886
	const6	      dw 6,6,6,6
;        xo            dw SIZE_X / 2  ; rotary point coodinates
;        zo            dw 0
;        yo            dw SIZE_Y / 2
	x_offset      dw SIZE_X / 2
	y_offset      dw SIZE_Y / 2
	z_offset      dw 0
	rsscale       dd 175.0		 ; next real scale
	vect_x	      dw SIZE_X / 2
	vect_y	      dw SIZE_Y / 2
	vect_z	      dw 0
	angle_x       dw 0
	angle_y       dw 0
	angle_z       dw 0
;spot_light_params:
;     dw      256,256,500         ; light position
;     db      80                       ;  .orginal_color_r
;     db      200                      ;  .orginal_color_g
;     db      115                      ;  .orginal_color_b

;     db      1                      ;  .min_color_r
;     db      1                      ;  .min_color_g
;     db      1                      ;  .min_color_b

;     db    240 ; 255                     ;  .max_color_r
;     db    255 ; 255                     ;  .max_color_g
;     db    255 ; 255                     ;  .max_color_b
;     db      255                      ;  .shine  255 - marker spot
;     dw      50000             ;          .light_fade


;spot_l_end:

menu:
	       db 2		   ; button number  = index
	       db 'rotary    '	   ; label
	       db 3		   ; max flag  + 1 , if = 255, no flag
 r_flag        db 1		   ; flag
	       dd axl_f 	   ; offset to flags description

	       db 3
	       db 'shd. model'
	       db 10
 dr_flag       db 0
	       dd shd_f

	       db 4
	       db 'speed     '
	       db 2
 speed_flag    db 0
	       dd spd_f

	       db 5
	       db 'zoom out  '
	       db 255
	       db ?
	       dd ?

	       db 6
	       db 'zoom in   '
	       db 255
	       db ?
	       dd ?

	       db 7
	       db 'catmull   '
	       db 2
catmull_flag   db 1
	       dd onoff_f

	       db 8
	       db 'culling   '
	       db 2
culling_flag   db 1
	       dd onoff_f

	       db 9
	       db 'rand.light'
	       db 255
	       db ?
	       dd ?

	       db 10
	       db 'blur      '
	       db 6
blur_flag      db 0
	       dd blur_f

	       db 11
	       db 'mirror x  '
	       db 2
mirr_x_flag    db 0
	       dd onoff_f

	       db 12
	       db 'mirror y  '
	       db 2
mirr_y_flag    db 0
	       dd onoff_f

	       db 13
	       db 'mirror z  '
	       db 2
mirr_z_flag    db 0
	       dd onoff_f

	       db 14
	       db 'xchg      '
	       db 4
xchg_flag      db 0
	       dd xchg_f

	       db 15
	       db 'emboss    '
	       db 2
emboss_flag    db 0
	       dd onoff_f

	       db 16
	       db 'fire      '
	       db 3
fire_flag      db 0
	       dd blur_f

	       db 17
	       db 'move      '
	       db 2
move_flag      db 0
	       dd move_f

		  db 18
		  db 'generate  '
		  db 6
generator_flag	  db 0
		  dd blur_f

	       db -1	   ; end mark


flags:		   ; flags description
 shd_f:
    db 'flat'
    db 'grd '
    db 'env '
    db 'bump'
    db 'tex '
    db 'pos '
    db 'dots'
    db 'txgr'
    db '2tex'
    db 'btex'
 spd_f:
    db 'idle'
    db 'full'
 axl_f:
    db ' y  '
    db 'x+y '
    db ' x  '
 onoff_f:
    db 'off '
    db 'on  '
  blur_f:	       ; blur, fire
    db 'off '
    db ' 1  '
    db ' 2  '
    db ' 3  '
    db ' 4  '
    db ' 5  '

 xchg_f:
    db 'no  '
    db 'x<>y'
    db 'z<>x'
    db 'y<>z'
 move_f:
    db 'obj '
    db 'camr'
;    db 'cscl'

    labelvector:
	db   'add vector'
    labelvectorend:
    labelyminus:
	db   'y -'
    labelyminusend:
    labelzplus:
	db   'z +'
    labelzplusend:
    labelxminus:
	db   'x -'
    labelxminusend:
    labelxplus:
	db   'x +'
    labelxplusend:
    labelzminus:
	db   'z -'
    labelzminusend:
    labelyplus:
	db   'y +'
    labelyplusend:

    labelt:
	db   'DEUS CARITAS EST'
      if Ext=MMX
	db   ' (MMX)'
      end if
      if Ext=SSE
	db   ' (SSE)'
      end if
	db   ' 0.04'
    labellen:
	STRdata db '-1        '
    all_lights_size dw lightsend-lights
if USE_LFN
file_info:
	dd	0
	dd	0
	dd	0
 fsize	dd	180000 ; sizeof(workarea)
	dd	workarea
file_name:
	db	'/rd/1/3d/teapot.3ds',0
else
     file_info:
	   dd 0
	   dd 0
    fsize  dd 1
	   dd workarea
	   dd hash_table
file_name:
      db   '/rd/1/teapot.3ds',0
end if
I_END:
      rb 256


lights rb LIGHT_SIZE * 3
lightsend:

hash_table rb 4096
SourceFile:
workarea   rb 180000
EndFile   dd ?
align 8
	sinbeta dd	?;+32
	cosbeta dd	?

	xsub	dw	?
	zsub	dw	?;+40
	ysub	dw	?

	xx1	dw	?
	yy1	dw	?
	zz1	dw	?;+48    xx1 + 4
	xx2	dw	?
	yy2	dw	?
	zz2	dw	?      ; xx1 + 10
	xx3	dw	?;+56
	yy3	dw	?
	zz3	dw	?      ; xx1 + 16
	scale	dd	?		  ; help scale variable
;        rsscalex      dd  ?
;        rsscaley      dd  ?
;        rsscalez      dd  ?
	triangles_count_var dw ?
	points_count_var    dw ?


	point_index1	    dw ?   ;-\
	point_index2	    dw ?   ;  }  don't change order
	point_index3	    dw ?   ;-/
	temp_col	    dw ?
   ;     color_sum_r         dd ?      ; ambient + diffuse + specular
   ;     color_sum_g         dd ?
   ;     color_sum_b         dd ?
	high		    dd ?
	rand_seed	    dw ?
align 8
	buffer	dq	?

	err	dd	?
	drr	dd	?
	xx	dd	?
	yy	dd	?
	xst	dd	?
	yst	dd	?
	screen_ptr	dd     ?
	Zbuffer_ptr	dd     ?

	matrix	rb 36
	cos_tab rd 360
	sin_tab rd 360
align 16
    points:
	rw (EndFile-SourceFile)/12*3
	points_count = ($-points)/6

    triangles:
	rw (EndFile-SourceFile)/12*3
	triangles_count = ($-triangles)/6
align 16
	real_points rd points_count*3 + 1
align 16
	rotated_points_r rd points_count*3 + 1
align 16
	points_rotated rw points_count*3 + 2 ;means translated
align 16
	label trizdd dword
	label trizdq qword
	triangles_with_z rw triangles_count*4 + 2 ; triangles triple dw + z position
align 16
	triangles_normals rb triangles_count * 12 ;
align 16
	point_normals rb points_count * 12  ;one 3dvector - triple float dword x,y,z
align 16
	point_normals_rotated rb points_count * 12
;align 16
;        triangles_normals_rotated rb triangles_count * 12
align 16
	vectors rb 24
;align 16
;        points_color rb 6*points_count    ; each color as word
;        sorted_triangles rw triangles_count*3 + 2
align 16
	bumpmap 	rb	TEXTURE_SIZE + 1
align 16
	bumpmap2	rb	TEXTURE_SIZE + 1
align 16
	envmap		rb	(TEXTURE_SIZE +1) * 3
align 16
	texmap		rb	(TEXTURE_SIZE +1) * 3
align 16
	color_map	rb	(TEXTURE_SIZE +1) * 3
align 16
	tex_points	rb	points_count * 4  ; bump_map  and texture coords
				; each point word x, word y
align 16
  ;      SourceFile:             ; source file temporally in screen area
  ;      workarea        dd      ?

    ;    screen          rb      SIZE_X * SIZE_Y * 3   ; screen buffer
;align 16
     ;   Z_buffer        rb      SIZE_X * SIZE_Y * 4
	I_Param 	rb	256
	memStack	rb	4000 ;memory area for stack
align  16
screen:
MEM_END:
